clear all
set more on
set mat 800
capture log close

cd "$E"

global path "E:\Project1_empirical" // global path file
global census  "$path\Census"     // census data
global city    "$path\City"       // city yearbook
global iv      "$path\IV"         // IV dataset
global chips   "$path\CHIPs"      // CHIPs dataset
global working_data = "$path\3rd Edition (Age 20 to 30)\Working Data" // working data be used in regression

use "$working_data\coredu", clear
order year, after(prefect)

rename cor_prefect hhsort
/* 168 prefectures 47 exclude or not
121 unique prefectures 
codebook prefect if year==2002 
2002 54 prefectures  20 to 30 1972 to 1982, 
2007 18 prefectures
2013 96 prefectures
*/

gen lnpopdensity=ln(popdensity)
gen lngdppc=ln(gdppc)
gen lnavewage=ln(avewage)
gen lnfdi=ln(fdi)
gen lndeposits=ln(deposits)
gen lntotpop=ln(totpop)
gen lnfixassetinv=ln(fixassetinv)
gen lncolleges=ln(colleges)
gen lnhighschools=ln(highschools)
gen lnnonarpop=ln(nonarpop)
gen lnpoppref=ln(poppref)
gen lntoneemployshare=ln(toneemployshare)
gen lnt2employshare=ln(t2employshare)
gen lnt3employshare=ln(t3employshare)
gen lnpop1564=ln(pop1564)
gen inter=srpref*hhsort
gen lnmwage=ln(mwage)


sum hhsort srpref /* mean(cor_cor_prefect) = .6537393 StD = .4934031 */
* mean(srpref) = 1.031167, StD = .0750475 *

* scatter cor_prefect srpref //scatter //

* twoway (scatter cor_prefect srpref) (lfit cor_prefect srpref)

global zlist1 lngdppc lnpop1564 lnpopdensity lncolleges

global zlist2 lnnonarpop lngdppc ///
lndeposits lnfixassetinv toneemployshare 

global zlist3 share1564 lnpopdensity lngdppc lnavewage lnfdi ///
lnfixassetinv toneemployshare lnt2employshare 

global zlist4 lnpopdensity lnpop1564 lngdppc lnfdi ///
lncolleges lnhighschools lnfixassetinv

global ylist1 "gini wage8020"

*———————————————————————————————————————————————————————————————————————————————
*vce(cluster prefect)
/* inequality and sorting */

foreach y in $ylist1 {

eststo: qui tobit `y' hhsort, ll vce(cluster prefect)

}
estout, cells(b(star fmt(%9.2f)) se(par)) starlevels(* .10 ** .05 *** .01) ///
        stats(r2_p N, fmt(%9.2f %9.0g) ) replace 

eststo clear		
		
foreach y in $ylist1 {

eststo: qui tobit `y' hhsort $zlist1, ll vce(cluster prefect)

}
estout, cells(b(star fmt(%9.2f)) se(par)) starlevels(* .10 ** .05 *** .01) ///
        stats(r2_p N, fmt(%9.2f %9.0g) ) replace 		
		
eststo clear		
		
foreach y in $ylist1 {

eststo: qui tobit `y' hhsort $zlist1 i.year, ll vce(cluster prefect)

}
estout, cells(b(star fmt(%9.2f)) se(par)) starlevels(* .10 ** .05 *** .01) ///
        stats(r2_p N, fmt(%9.2f %9.0g) ) replace 			
				
eststo clear			
		
*———————————————————————————————————————————————————————————————————————————————

/* inequality and sex ratio */		
foreach y in $ylist1 {

eststo: qui tobit `y' srpref, ll vce(cluster prefect)

}
estout, cells(b(star fmt(%9.2f)) se(par)) starlevels(* .10 ** .05 *** .01) ///
        stats(r2_p N, fmt(%9.2f %9.0g) ) replace 

eststo clear		
		
foreach y in $ylist1 {

eststo: qui tobit `y' srpref $zlist1, ll vce(cluster prefect)

}
estout, cells(b(star fmt(%9.2f)) se(par)) starlevels(* .10 ** .05 *** .01) ///
        stats(r2_p N, fmt(%9.2f %9.0g) ) replace 		
		
eststo clear		
		
foreach y in $ylist1 {

eststo: qui tobit `y' srpref $zlist1 i.year, ll vce(cluster prefect)

}
estout, cells(b(star fmt(%9.2f)) se(par)) starlevels(* .10 ** .05 *** .01) ///
        stats(r2_p N, fmt(%9.2f %9.0g) ) replace 			

eststo clear
*———————————————————————————————————————————————————————————————————————————————
		


/* IV */		
foreach y in $ylist1 {

eststo: qui ivtobit `y' (hhsort=srpref), ll vce(cluster prefect)

}
estout, cells(b(star fmt(%9.2f)) se(par)) starlevels(* .10 ** .05 *** .01) ///
        stats(r2_p N, fmt(%9.2f %9.0g) ) replace 

eststo clear		
		
foreach y in $ylist1 {

eststo: qui ivtobit `y' (hhsort=srpref) $zlist1, ll 

}
estout, cells(b(star fmt(%9.2f)) se(par)) starlevels(* .10 ** .05 *** .01) ///
        stats(r2_p N, fmt(%9.2f %9.0g) ) replace 		
		
eststo clear		
		
foreach y in $ylist1 {

eststo: qui ivtobit `y' (hhsort=srpref) $zlist1 i.year, ll r

}
estout, cells(b(star fmt(%9.2f)) se(par)) starlevels(* .10 ** .05 *** .01) ///
        stats(r2_p N, fmt(%9.2f %9.0g) ) replace 			

*———————————————————————————————————————————————————————————————————————————————
		












